﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Utilities;
    using Microsoft.SharePoint.WebControls;
    using System;
    using System.Collections.Generic;
    using System.Globalization;
    using System.IO;
    using System.Web.UI;
    
    /// <summary>
    /// ASP.NET user control implementing the SharePoint design time HTML provider interface to provide
    /// custom suite bar links.
    /// </summary>
    public class CustomSuiteBarLinks  : UserControl, IDesignTimeHtmlProvider
    {
        // Override the CreateChildControls method to add our custom JavaScript to the page
        protected override void CreateChildControls()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSuiteBarLinks::CreateChildControls"))
            {
                // Get the server relative URL for the custom JavaScript
                var url = SPContext.Current.Web.ServerRelativeUrl.TrimEnd('/') + "/_layouts/15/Code6587EN.Ch07/CustomSuiteBarLinks.js";

                // Register the JavaScript with the ClientScriptManager
                this.Page.ClientScript.RegisterClientScriptInclude("CustomSuiteBarLinks", url);

                // Instruct SharePoint to load the SP.js, SP.UI.MySiteNavigation.js, SuiteLinks.js, and MyLinks.js 
                // JavaScript files included with SharePoint out-of-the-box
                ScriptLink.RegisterScriptAfterUI(this, this.Page, "sp.js", false);
                ScriptLink.RegisterScriptAfterUI(this, this.Page, "SP.UI.MySiteNavigation.js", false);
                ScriptLink.RegisterScriptAfterUI(this, this.Page, "suitelinks.js", false);
                ScriptLink.RegisterScriptAfterUI(this, this.Page, "MyLinks.js", false);
            }
        }

        // Implement the GetDesignTimeHtml method from the IDesignTimeHtmlProvider interface
        // to return the HTML to render
        public string GetDesignTimeHtml()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSuiteBarLinks::GetDesignTimeHtml"))
            {
                // Instantiate a new HtmlTextWriter object to construct the HTML for the promoted action
                StringWriter writer = new StringWriter(CultureInfo.CurrentCulture);
                HtmlTextWriter writer2 = new HtmlTextWriter(writer);

                // Call the overridden Render method to construct the HTML
                this.Render(writer2);
                writer2.Close();

                // Return the HTML constructed by the Render method
                return writer.ToString();
            }
        }

        // Override the Render method to be used by the GetDesignTimeHtml method to construct the HTML to render
        protected override void Render(HtmlTextWriter writer)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSuiteBarLinks::GetDesignTimeHtml"))
            {
                // Add the container element for the suite links bar
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_NavBar");
                writer.RenderBeginTag(HtmlTextWriterTag.Div);

                // Add the unordered list element used to render and format the links 
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_TopMenu");
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-suiteLinkList");
                writer.RenderBeginTag(HtmlTextWriterTag.Ul);

                // Use our RenderSuiteLink method to add links to the list element
                RenderSuiteLink(writer, "/", "Home", "suiteLinkHome", true);
                RenderSuiteLink(writer, "http://www.bing.com", "Bing", "suiteLinkBing", false);

                // Create the collection of links to render in the drop down menu
                // A class or other method of creating this collection would be fine.  We are using a tuple 
                // for simplicity.
                var subItems = new List<Tuple<string, string, string>>();
                subItems.Add(new Tuple<string, string, string>("Google", "suiteLinkGoogle", "http://www.google.com"));
                subItems.Add(new Tuple<string, string, string>("Yahoo", "suiteLinkYahoo", "http://www.yahoo.com"));

                // Use our RenderSuiteLinkMenu method to render the drop down menu
                RenderSuiteLinkMenu(writer, "Search Engines", "suiteLinkMenuSearch", subItems);

                // Add the end tag for the unordered list element
                writer.RenderEndTag();

                // Add the end tag for the conatiner element
                writer.RenderEndTag();
            }
        }

        // Method to render an individual suite bar link
        private static void RenderSuiteLink(HtmlTextWriter writer, string url, string name, string linkId, bool isActiveLink)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSuiteBarLinks::GetDesignTimeHtml"))
            {
                // Create the list item element to add to the unordered list element
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-suiteLink");
                writer.RenderBeginTag(HtmlTextWriterTag.Li);

                // Create the link element
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-suiteLink-a");
                writer.AddAttribute(HtmlTextWriterAttribute.Href, url);
                writer.AddAttribute(HtmlTextWriterAttribute.Id, linkId);
                writer.RenderBeginTag(HtmlTextWriterTag.A);

                // Create the span element to contain the text within the link
                writer.RenderBeginTag(HtmlTextWriterTag.Span);

                // Add the text to display as the link
                writer.Write(name);

                // If this is the "active" link
                if (isActiveLink)
                {
                    // Create the span element to contain the carat image
                    writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_ActiveLinkIndicator_Clip");
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-suitenav-caratBox");
                    writer.RenderBeginTag(HtmlTextWriterTag.Span);

                    // Create the img element for the carat image
                    writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_ActiveLinkIndicator");
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-suitenav-caratIcon");
                    writer.AddAttribute(HtmlTextWriterAttribute.Src, SPUtility.GetThemedImageUrl(SPUrlUtility.CombineUrl(SPUtility.ContextImagesRoot, "spcommon.png"), "spcommon"));
                    writer.RenderBeginTag(HtmlTextWriterTag.Img);

                    // Add the end tag for the img element
                    writer.RenderEndTag();

                    // Add the end tag for the span element
                    writer.RenderEndTag();
                }

                // Add the end tag for the span element
                writer.RenderEndTag();

                // Add the end tag for the link element
                writer.RenderEndTag();

                // Add the end tag for the list item element
                writer.RenderEndTag();
            }
        }

        // Method to render the suite bar drop down menu
        private static void RenderSuiteLinkMenu(HtmlTextWriter writer, string name, string menuId, List<Tuple<string, string, string>> subItems)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSuiteBarLinks::GetDesignTimeHtml"))
            {
                // Create the list item element to add the menu link and menu to the unordered list
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-suiteLink");
                writer.RenderBeginTag(HtmlTextWriterTag.Li);

                // Create the link element to display the menu link
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-suiteLink-a");
                writer.AddAttribute(HtmlTextWriterAttribute.Href, "#");
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_MainLink_" + menuId);
                // Add the JavaScript handlers for the onfocus, onclick, and onblur events
                writer.AddAttribute("onfocus", "CustomSuiteBarMenu_ShowMenu('Suite_MainLink_" + menuId + "', 'Suite_PopupMenu_" + menuId + "', 'Suite_NavBar');");
                writer.AddAttribute("onclick", "CustomSuiteBarMenu_ShowMenu('Suite_MainLink_" + menuId + "', 'Suite_PopupMenu_" + menuId + "', 'Suite_NavBar');");
                writer.AddAttribute("onblur", "CustomSuiteBarMenu_Hide('Suite_PopupMenu_" + menuId + "', 'Suite_MainLink_" + menuId + "');");
                writer.RenderBeginTag(HtmlTextWriterTag.A);

                // Create the span element to contain the display text and drop down menu icon
                writer.AddAttribute("onblur", "CustomSuiteBarMenu_Hide('Suite_PopupMenu_" + menuId + "', 'Suite_MainLink_" + menuId + "');");
                writer.RenderBeginTag(HtmlTextWriterTag.Span);

                // Add the text to display
                writer.Write(name);

                // Create the span element to contain the drop down icon
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-suitenav-downarrowBox");
                writer.AddAttribute("onblur", "CustomSuiteBarMenu_Hide('Suite_PopupMenu_" + menuId + "', 'Suite_MainLink_" + menuId + "');");
                writer.RenderBeginTag(HtmlTextWriterTag.Span);

                // Create the img element for the drop down icon
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-suitenav-downarrowIcon");
                writer.AddAttribute(HtmlTextWriterAttribute.Src, SPUtility.GetThemedImageUrl(SPUrlUtility.CombineUrl(SPUtility.ContextImagesRoot, "spcommon.png"), "spcommon"));
                writer.RenderBeginTag(HtmlTextWriterTag.Img);

                // Add the end tag for the img element
                writer.RenderEndTag();

                // Add the end tag for the span element
                writer.RenderEndTag();

                // Add the end tag for the span element
                writer.RenderEndTag();

                // Add the end tag for the link element
                writer.RenderEndTag();

                // Create the drop down menu container element
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-box ms-core-suitemenu");
                writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_PopupMenu_" + menuId);
                writer.RenderBeginTag(HtmlTextWriterTag.Div);

                // Create the unordered list element to render the drop down menu items
                writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-list");
                writer.RenderBeginTag(HtmlTextWriterTag.Ul);

                // Add the elements to render each menu item
                foreach (var subItem in subItems)
                {
                    // Create the list item element to contain the menu item
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-item");
                    writer.RenderBeginTag(HtmlTextWriterTag.Li);

                    // Create the link element for the menu item
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-link");
                    writer.AddAttribute(HtmlTextWriterAttribute.Href, subItem.Item3);
                    writer.AddAttribute(HtmlTextWriterAttribute.Id, "Suite_SubLink_" + subItem.Item2);
                    writer.RenderBeginTag(HtmlTextWriterTag.A);

                    // Create the container for the menu item label
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-label");
                    writer.RenderBeginTag(HtmlTextWriterTag.Div);

                    // Create the span element to contain the display text
                    writer.AddAttribute(HtmlTextWriterAttribute.Class, "ms-core-menu-title");
                    writer.RenderBeginTag(HtmlTextWriterTag.Span);

                    // Add the display text
                    writer.Write(subItem.Item1);

                    // Add the end tag for the span element
                    writer.RenderEndTag();

                    // Add the end tag for the menu item label
                    writer.RenderEndTag();

                    // Add the end tag for the link element
                    writer.RenderEndTag();

                    // Add the end tag for the list item element
                    writer.RenderEndTag();
                }

                // Add the end tag for the unordered list element
                writer.RenderEndTag();

                // Add the end tag for the drop down menu container element
                writer.RenderEndTag();

                // Add the end tag for the list item element
                writer.RenderEndTag();
            }
        }
    }
}
